/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.java.JavaI18nFinder;
import org.netbeans.modules.i18n.wizard.HardStringWizardPanel;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.SourceWizardPanel;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class TestStringWizardPanel
extends JPanel {
    private static final int COLUMN_INDEX_CHECK = 0;
    private static final int COLUMN_INDEX_HARDSTRING = 1;
    private static final int COLUMN_INDEX_KEY = 2;
    private static final int COLUMN_INDEX_VALUE = 3;
    private final Map<DataObject, SourceData> sourceMap = Util.createWizardSourceMap();
    private final AbstractTableModel tableModel = new TestStringTableModel();
    private JScrollPane scrollPane;
    private JComboBox sourceCombo;
    private JLabel sourceLabel;
    private JLabel testStringLabel;
    private JTable testStringTable;

    private TestStringWizardPanel() {
        this.initComponents();
        this.postInitComponents();
        this.initTable();
        this.setComboModel(this.sourceMap);
        HelpCtx.setHelpIDString((JComponent)this, (String)"internation.FoundMissingResources");
    }

    private void setComboModel(Map<DataObject, SourceData> sourceMap) {
        ArrayList<DataObject> nonEmptySources = new ArrayList<DataObject>();
        for (Map.Entry<DataObject, SourceData> entry : sourceMap.entrySet()) {
            if (entry.getValue().getStringMap().isEmpty()) continue;
            nonEmptySources.add(entry.getKey());
        }
        this.sourceCombo.setModel(new DefaultComboBoxModel<Object>(nonEmptySources.toArray()));
    }

    private void postInitComponents() {
        this.sourceLabel.setLabelFor(this.sourceCombo);
        this.testStringLabel.setLabelFor(this.testStringTable);
    }

    public Map<DataObject, SourceData> getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map<DataObject, SourceData> sourceMap) {
        this.sourceMap.clear();
        this.sourceMap.putAll(sourceMap);
        this.setComboModel(sourceMap);
    }

    private Map<HardCodedString, I18nString> getStringMap() {
        SourceData sourceData = this.sourceMap.get(this.sourceCombo.getSelectedItem());
        return sourceData == null ? null : sourceData.getStringMap();
    }

    private Set<HardCodedString> getRemovedStrings() {
        SourceData sourceData = this.sourceMap.get(this.sourceCombo.getSelectedItem());
        if (sourceData == null) {
            return null;
        }
        if (sourceData.getRemovedStrings() == null) {
            sourceData.setRemovedStrings(new HashSet<HardCodedString>());
        }
        return sourceData.getRemovedStrings();
    }

    private void initTable() {
        this.testStringTable.setDefaultRenderer(HardCodedString.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                I18nSupport.I18nFinder finder;
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                HardCodedString hcString = (HardCodedString)value;
                label.setText(hcString != null ? hcString.getText() : "");
                SourceData data = TestStringWizardPanel.this.sourceMap.get(TestStringWizardPanel.this.sourceCombo.getSelectedItem());
                I18nSupport support = data.getSupport();
                if (support != null && (finder = support.getFinder()) instanceof JavaI18nFinder && label != null && hcString != null) {
                    HardCodedString newHCstring = ((JavaI18nFinder)finder).modifyHCStringText(hcString);
                    label.setText(newHCstring != null ? newHCstring.getText() : hcString.getText());
                }
                return label;
            }
        });
        this.testStringTable.setDefaultRenderer(I18nString.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                I18nString i18nString = (I18nString)value;
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                int modelColumn = TestStringWizardPanel.this.testStringTable.convertColumnIndexToModel(column);
                if (i18nString != null) {
                    label.setText(modelColumn == 2 ? i18nString.getKey() : i18nString.getValue());
                } else {
                    label.setText("");
                }
                return label;
            }
        });
        this.testStringTable.setDefaultEditor(I18nString.class, new DefaultCellEditor(new JTextField()){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                I18nString i18nString = (I18nString)value;
                int modelColumn = TestStringWizardPanel.this.testStringTable.convertColumnIndexToModel(column);
                value = modelColumn == 2 ? (i18nString == null ? "" : i18nString.getKey()) : (modelColumn == 3 ? (i18nString == null ? "" : i18nString.getValue()) : "");
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
        });
        this.testStringTable.getColumnModel().getColumn(0).setMaxWidth(30);
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceCombo = new JComboBox();
        this.testStringLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.testStringTable = new JTable();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getBundle(HardStringWizardPanel.class).getString("LBL_Source"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceLabel, gridBagConstraints);
        this.sourceCombo.setRenderer(new SourceWizardPanel.DataObjectListCellRenderer());
        this.sourceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestStringWizardPanel.this.sourceComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.sourceCombo, gridBagConstraints);
        this.sourceCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestStringWizardPanel.class, (String)"LBL_Source_Accessible_Name"));
        this.sourceCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestStringWizardPanel.class, (String)"LBL_Source_Accessible_Description"));
        Mnemonics.setLocalizedText((JLabel)this.testStringLabel, (String)NbBundle.getBundle(HardStringWizardPanel.class).getString("LBL_missing_keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.testStringLabel, gridBagConstraints);
        this.scrollPane.setPreferredSize(new Dimension(100, 100));
        this.testStringTable.setModel(this.tableModel);
        this.scrollPane.setViewportView(this.testStringTable);
        this.testStringTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestStringWizardPanel.class, (String)"LBL_FoundStrings_Accessible_Name"));
        this.testStringTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestStringWizardPanel.class, (String)"LBL_FoundStrings_Accessible_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.scrollPane.getAccessibleContext().setAccessibleName("Found Strings with Missing Keys");
        this.scrollPane.getAccessibleContext().setAccessibleDescription("Found Strings with Missing Keys");
    }

    private void sourceComboActionPerformed(ActionEvent evt) {
        if (this.sourceMap.get(this.sourceCombo.getSelectedItem()).getStringMap().isEmpty()) {
            JLabel label = new JLabel(NbBundle.getMessage(TestStringWizardPanel.class, (String)"TXT_AllI18nStringsSource"));
            label.setHorizontalAlignment(0);
            this.scrollPane.setViewportView(label);
        } else {
            this.scrollPane.setViewportView(this.testStringTable);
            this.tableModel.fireTableDataChanged();
        }
        this.tableModel.fireTableDataChanged();
    }

    private class TestStringTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            Map<HardCodedString, I18nString> stringMap = TestStringWizardPanel.this.getStringMap();
            return stringMap == null ? 0 : stringMap.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Map<HardCodedString, I18nString> stringMap = TestStringWizardPanel.this.getStringMap();
            if (stringMap == null) {
                return null;
            }
            if (columnIndex == 0) {
                return !TestStringWizardPanel.this.getRemovedStrings().contains(stringMap.keySet().toArray()[rowIndex]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (columnIndex == 1) {
                return stringMap.keySet().toArray()[rowIndex];
            }
            return stringMap.values().toArray()[rowIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 3;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Map<HardCodedString, I18nString> stringMap = TestStringWizardPanel.this.getStringMap();
            if (stringMap == null) {
                return;
            }
            if (columnIndex == 0 && value instanceof Boolean) {
                HardCodedString[] hardCodedStrings = stringMap.keySet().toArray(new HardCodedString[stringMap.size()]);
                HardCodedString hardString = hardCodedStrings[rowIndex];
                Set<HardCodedString> removedStrings = TestStringWizardPanel.this.getRemovedStrings();
                if (((Boolean)value).booleanValue()) {
                    removedStrings.remove(hardString);
                } else {
                    removedStrings.add(hardString);
                }
            }
            if (columnIndex == 3) {
                Collection<I18nString> i18nStrings = TestStringWizardPanel.this.getStringMap().values();
                I18nString i18nString = i18nStrings.toArray(new I18nString[0])[rowIndex];
                i18nString.setValue(value.toString());
            }
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 1) {
                return HardCodedString.class;
            }
            return I18nString.class;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 1) {
                return NbBundle.getMessage(HardStringWizardPanel.class, (String)"LBL_HardString");
            }
            if (column == 2) {
                return NbBundle.getMessage(HardStringWizardPanel.class, (String)"LBL_Key");
            }
            if (column == 3) {
                return NbBundle.getMessage(HardStringWizardPanel.class, (String)"LBL_Value");
            }
            return " ";
        }
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel
    implements WizardDescriptor.FinishablePanel<I18nWizardDescriptor.Settings>,
    WizardDescriptor.AsynchronousValidatingPanel<I18nWizardDescriptor.Settings> {
        private static final String CARD_GUI = "gui";
        private static final String CARD_MSG = "msg";
        private static final String CARD_REPLACING = "replacing";
        private JLabel emptyLabel;
        private transient TestStringWizardPanel testStringPanel;
        private volatile boolean hasFoundStrings;
        private volatile ProgressWizardPanel progressPanel;

        @Override
        protected Component createComponent() {
            JPanel panel = new JPanel(new CardLayout());
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestStringWizardPanel.class, (String)"ACS_TestStringWizardPanel"));
            panel.putClientProperty("WizardPanel_contentSelectedIndex", 2);
            panel.setName(NbBundle.getMessage(TestStringWizardPanel.class, (String)"TXT_FoundMissingResource"));
            panel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            return panel;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        public boolean isFinishPanel() {
            return true;
        }

        @Override
        public void readSettings(I18nWizardDescriptor.Settings settings) {
            super.readSettings(settings);
            this.getUI().setSourceMap(this.getMap());
            this.hasFoundStrings = Panel.foundStrings(this.getMap());
            JPanel panel = (JPanel)this.getComponent();
            if (this.hasFoundStrings) {
                panel.add((Component)this.getUI(), CARD_GUI);
                ((CardLayout)panel.getLayout()).show(panel, CARD_GUI);
            } else {
                panel.add((Component)this.getMessageComp(), CARD_MSG);
                ((CardLayout)panel.getLayout()).show(panel, CARD_MSG);
            }
        }

        @Override
        public void storeSettings(I18nWizardDescriptor.Settings settings) {
            super.storeSettings(settings);
            this.getMap().clear();
            this.getMap().putAll(this.getUI().getSourceMap());
        }

        public void prepareValidation() {
            assert (EventQueue.isDispatchThread());
            if (this.hasFoundStrings) {
                this.progressPanel = new ProgressWizardPanel(true);
                this.progressPanel.setMainText(NbBundle.getMessage(this.getClass(), (String)"LBL_Internationalizing"));
                this.progressPanel.setMainProgress(0);
                Container container = (Container)this.getComponent();
                container.add((Component)this.progressPanel, CARD_REPLACING);
                ((CardLayout)container.getLayout()).show(container, CARD_REPLACING);
            }
        }

        public void validate() throws WizardValidationException {
            assert (!EventQueue.isDispatchThread());
            if (this.hasFoundStrings) {
                Map<DataObject, SourceData> sourceMap = this.getUI().getSourceMap();
                int counterOuter = 0;
                for (Map.Entry<DataObject, SourceData> srcMapEntry : sourceMap.entrySet()) {
                    ++counterOuter;
                    DataObject source = srcMapEntry.getKey();
                    SourceData sourceData = srcMapEntry.getValue();
                    I18nSupport support = sourceData.getSupport();
                    Map<HardCodedString, I18nString> stringMap = sourceData.getStringMap();
                    Set<HardCodedString> removed = sourceData.getRemovedStrings();
                    ClassPath cp = ClassPath.getClassPath((FileObject)source.getPrimaryFile(), (String)"classpath/source");
                    this.progressPanel.setSubText(Util.getString("LBL_Source") + " " + cp.getResourceName(source.getPrimaryFile(), '.', false));
                    int counterInner = 0;
                    for (Map.Entry<HardCodedString, I18nString> entry : stringMap.entrySet()) {
                        ++counterInner;
                        HardCodedString hcString = entry.getKey();
                        I18nString i18nString = entry.getValue();
                        if (removed != null && removed.contains(hcString)) continue;
                        Object comment = i18nString.getComment();
                        if (comment == null || "".equals(comment)) {
                            DataObject dobj = source;
                            cp = ClassPath.getClassPath((FileObject)dobj.getPrimaryFile(), (String)"classpath/source");
                            comment = cp.getResourceName(dobj.getPrimaryFile(), '.', false);
                        }
                        String key = i18nString.getKey();
                        String prev = support.getResourceHolder().getCommentForKey(key);
                        comment = (String)comment + (String)(prev == null ? "" : " " + prev);
                        support.getResourceHolder().addProperty(i18nString.getKey(), i18nString.getValue(), (String)comment, false);
                        this.progressPanel.setSubProgress((int)((float)counterInner / (float)stringMap.size() * 100.0f));
                    }
                    if (support.hasAdditionalCustomizer()) {
                        support.performAdditionalChanges();
                    }
                    this.progressPanel.setMainProgress((int)((float)counterOuter / (float)sourceMap.size() * 100.0f));
                }
            }
        }

        private static boolean foundStrings(Map<DataObject, SourceData> sourceMap) {
            for (Map.Entry<DataObject, SourceData> entry : sourceMap.entrySet()) {
                if (entry.getValue().getStringMap().isEmpty()) continue;
                return true;
            }
            return false;
        }

        public HelpCtx getHelp() {
            return new HelpCtx("internation.testing");
        }

        private synchronized TestStringWizardPanel getUI() {
            if (this.testStringPanel == null) {
                this.testStringPanel = new TestStringWizardPanel();
            }
            return this.testStringPanel;
        }

        private JComponent getMessageComp() {
            if (this.emptyLabel == null) {
                this.emptyLabel = new JLabel(NbBundle.getMessage(TestStringWizardPanel.class, (String)"TXT_AllI18nStrings"));
                this.emptyLabel.setHorizontalAlignment(0);
                this.emptyLabel.setVerticalAlignment(0);
            }
            return this.emptyLabel;
        }
    }

    public static class CustomizeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private I18nString i18nString;
        private JButton editorComponent = new JButton("...");

        public CustomizeCellEditor() {
            this.editorComponent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PropertyPanel panel = i18nString.getSupport().getPropertyPanel();
                    panel.setI18nString(i18nString);
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, "Customize Property");
                    dd.setModal(true);
                    dd.setOptionType(-1);
                    dd.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
                    dd.setAdditionalOptions(new Object[0]);
                    dd.setButtonListener((ActionListener)this);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                    dialog.setVisible(true);
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.i18nString = (I18nString)value;
            return this.editorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            return this.i18nString;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 1;
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.stopCellEditing();
        }
    }
}

